const { exec } = require('child_process');

console.log('🚀 Starting database setup for PropMaster.io...');

const runCommand = (command, description) => {
  return new Promise((resolve, reject) => {
    console.log(`📋 Running: ${description}`);

    exec(command, (error, stdout, stderr) => {
      if (error) {
        console.error(`❌ Error ${description}:`, error.message);
        reject(error);
        return;
      }

      if (stderr) {
        console.log(`⚠️  Warnings ${description}:`, stderr);
      }

      console.log(`✅ ${description} completed successfully`);
      if (stdout) {
        console.log(`📄 Output:`, stdout);
      }

      resolve(stdout);
    });
  });
};

async function setupDatabase() {
  try {
    // Step 1: Generate Prisma client
    await runCommand('npx prisma generate', 'Generating Prisma client');

    // Step 2: Push database schema
    await runCommand('npx prisma db push', 'Pushing database schema');

    // Step 3: Seed the database
    await runCommand('npm run db:seed', 'Seeding database with initial data');

    console.log('🎉 Database setup completed successfully!');
    console.log('📊 Your PropMaster.io application is ready to use.');

  } catch (error) {
    console.error('💥 Database setup failed:', error);
    process.exit(1);
  }
}

// Run the setup
setupDatabase();