<?php
// run-setup.php - Execute database setup via PHP for cPanel
echo "<h1>PropMaster.io Database Setup</h1>";
echo "<pre>";

// Function to execute commands
function runCommand($command, $description) {
    echo "📋 Running: $description\n";
    $output = shell_exec($command . ' 2>&1');
    echo "Output: $output\n\n";
    return $output;
}

// Change to application directory
chdir('/home/your-cpanel-username/public_html'); // Update this to your actual cPanel username

echo "Current directory: " . getcwd() . "\n\n";

// Check if Node.js is available
echo "Checking Node.js...\n";
runCommand('node --version', 'Node.js version check');
runCommand('npm --version', 'NPM version check');

echo "Starting database setup...\n\n";

// Run setup commands
runCommand('npx prisma generate', 'Generating Prisma client');
runCommand('npx prisma db push', 'Pushing database schema');
runCommand('npm run db:seed', 'Seeding database with initial data');

echo "✅ Database setup completed!\n";
echo "🎉 Your PropMaster.io application should now be ready.\n\n";

echo "Next steps:\n";
echo "1. Remove this setup file for security\n";
echo "2. Access your application at https://propmaster.org\n";
echo "3. Default login: Check DEPLOYMENT_README.md for credentials\n";

echo "</pre>";
?>