const { PrismaClient } = require('@prisma/client')

const prisma = new PrismaClient()

async function main() {
  console.log('🔄 Updating owner agreement document paths...')

  try {
    // Update John Smith's agreement document path
    const johnUpdate = await prisma.user.updateMany({
      where: {
        email: 'john.smith@propmaster.io',
        role: 'owner'
      },
      data: {
        agreementDocument: '/uploads/agreements/sample-john-smith-agreement.txt'
      }
    })

    // Update Sarah Johnson's agreement document path
    const sarahUpdate = await prisma.user.updateMany({
      where: {
        email: 'sarah.johnson@propmaster.io',
        role: 'owner'
      },
      data: {
        agreementDocument: '/uploads/agreements/sample-sarah-johnson-agreement.txt'
      }
    })

    console.log(`✅ Updated ${johnUpdate.count} record(s) for John Smith`)
    console.log(`✅ Updated ${sarahUpdate.count} record(s) for Sarah Johnson`)

    // Verify the updates
    const owners = await prisma.user.findMany({
      where: {
        role: 'owner',
        email: {
          in: ['john.smith@propmaster.io', 'sarah.johnson@propmaster.io']
        }
      },
      select: {
        email: true,
        agreementDocument: true
      }
    })

    console.log('\n📋 Current owner agreement documents:')
    owners.forEach(owner => {
      console.log(`${owner.email}: ${owner.agreementDocument}`)
    })

  } catch (error) {
    console.error('❌ Error updating owner files:', error.message)
  } finally {
    await prisma.$disconnect()
  }
}

main()