const { PrismaClient } = require('@prisma/client')
const bcrypt = require('bcryptjs')

const prisma = new PrismaClient()

async function createSuperAdmin() {
  try {
    console.log('Creating Super Admin user...')

    // Hash the password
    const hashedPassword = await bcrypt.hash('superadmin123', 12)

    // Create the super admin user
    const superAdmin = await prisma.user.create({
      data: {
        email: 'superadmin@propmaster.io',
        passwordHash: hashedPassword,
        firstName: 'Super',
        lastName: 'Admin',
        role: 'super_admin',
        emailVerified: true,
        phone: '+256700000000',
      }
    })

    console.log('Super Admin created successfully!')
    console.log('Email: superadmin@propmaster.io')
    console.log('Password: superadmin123')
    console.log('User ID:', superAdmin.id)

  } catch (error) {
    console.error('Error creating Super Admin:', error)
  } finally {
    await prisma.$disconnect()
  }
}

createSuperAdmin()