const { PrismaClient } = require('@prisma/client')

const prisma = new PrismaClient()

async function checkUsers() {
  try {
    console.log('Checking users in database...')

    // Check users table
    const users = await prisma.user.findMany({
      select: {
        id: true,
        email: true,
        firstName: true,
        lastName: true,
        role: true,
        passwordHash: true
      }
    })

    console.log('\n=== USERS TABLE ===')
    users.forEach(user => {
      console.log(`${user.email} - ${user.role} - Has password: ${!!user.passwordHash}`)
    })

    // Check tenants table
    const tenants = await prisma.tenant.findMany({
      select: {
        id: true,
        email: true,
        firstName: true,
        lastName: true,
        passwordHash: true
      }
    })

    console.log('\n=== TENANTS TABLE ===')
    tenants.forEach(tenant => {
      console.log(`${tenant.email} - Has password: ${!!tenant.passwordHash}`)
    })

    // Check for overlapping emails
    const userEmails = new Set(users.map(u => u.email))
    const overlappingEmails = tenants.filter(t => userEmails.has(t.email))

    console.log('\n=== OVERLAPPING EMAILS ===')
    overlappingEmails.forEach(tenant => {
      console.log(`${tenant.email} exists in both tables`)
    })

  } catch (error) {
    console.error('Error checking users:', error)
  } finally {
    await prisma.$disconnect()
  }
}

checkUsers()