-- MariaDB dump 10.19  Distrib 10.4.32-MariaDB, for Win64 (AMD64)
--
-- Host: localhost    Database: propmaster_db
-- ------------------------------------------------------
-- Server version	10.4.32-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `chats`
--

DROP TABLE IF EXISTS `chats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chats` (
  `id` varchar(191) NOT NULL,
  `senderId` varchar(191) DEFAULT NULL,
  `receiverId` varchar(191) DEFAULT NULL,
  `tenantId` varchar(191) DEFAULT NULL,
  `companyId` varchar(191) DEFAULT NULL,
  `message` varchar(191) NOT NULL,
  `timestamp` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `sessionId` varchar(191) DEFAULT NULL,
  `status` varchar(191) NOT NULL DEFAULT 'sent',
  `attachments` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`attachments`)),
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `updatedAt` datetime(3) NOT NULL,
  `direction` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chats_tenantId_fkey` (`tenantId`),
  KEY `chats_companyId_fkey` (`companyId`),
  CONSTRAINT `chats_companyId_fkey` FOREIGN KEY (`companyId`) REFERENCES `companies` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `chats_tenantId_fkey` FOREIGN KEY (`tenantId`) REFERENCES `tenants` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chats`
--

LOCK TABLES `chats` WRITE;
/*!40000 ALTER TABLE `chats` DISABLE KEYS */;
INSERT INTO `chats` VALUES ('cmfyki8ek000zwjo0iw7g6ymk','cmftyt6110009wjtcgfgbz5el','cmfuvubvx0001wj7chgmj13zk','cmfuvubvx0001wj7chgmj13zk','cmftyt5y60005wjtc0u84j1r3','Hellooo','2025-09-24 22:40:38.148',NULL,'sent','[]','2025-09-24 22:40:38.148','2025-09-24 22:40:38.148',NULL),('cmfykj4zu0011wjo0hpxxze0e','cmfuvubvx0001wj7chgmj13zk','cmftyt6110009wjtcgfgbz5el','cmfuvubvx0001wj7chgmj13zk','cmftyt5y60005wjtc0u84j1r3','Yes please, nice to hear from you Richard','2025-09-24 22:41:20.395',NULL,'sent','[]','2025-09-24 22:41:20.395','2025-09-24 22:41:20.395',NULL),('cmfykkxuv0013wjo0v0lmz64v','cmftyt6110009wjtcgfgbz5el','cmfuvubvx0001wj7chgmj13zk','cmfuvubvx0001wj7chgmj13zk','cmftyt5y60005wjtc0u84j1r3','Me as well, how are you finding your new home','2025-09-24 22:42:44.455',NULL,'sent','[]','2025-09-24 22:42:44.455','2025-09-24 22:42:44.455',NULL),('cmfyklxdn0015wjo0a5mdmuuf','cmfuvubvx0001wj7chgmj13zk','cmftyt6110009wjtcgfgbz5el','cmfuvubvx0001wj7chgmj13zk','cmftyt5y60005wjtc0u84j1r3','Cool, my new home is quiet nice.. looking forward to spending some good time hear.🥰','2025-09-24 22:43:30.491',NULL,'sent','[]','2025-09-24 22:43:30.491','2025-09-24 22:43:30.491',NULL),('cmfykmyii0017wjo0iljbqxqz','cmftyt6110009wjtcgfgbz5el','cmfuvubvx0001wj7chgmj13zk','cmfuvubvx0001wj7chgmj13zk','cmftyt5y60005wjtc0u84j1r3','Thats amazing, nice stay','2025-09-24 22:44:18.618',NULL,'sent','[]','2025-09-24 22:44:18.618','2025-09-24 22:44:18.618',NULL),('cmfyknlqx0019wjo0uyiijvsc','cmfuvubvx0001wj7chgmj13zk','cmftyt6110009wjtcgfgbz5el','cmfuvubvx0001wj7chgmj13zk','cmftyt5y60005wjtc0u84j1r3','🙏🙏','2025-09-24 22:44:48.729',NULL,'sent','[]','2025-09-24 22:44:48.729','2025-09-24 22:44:48.729',NULL),('cmfykpfbt001bwjo0yubztfde','cmftyt6110009wjtcgfgbz5el',NULL,'cmfubcj7i0005wj6o9l60a84e','cmftyt5y60005wjtc0u84j1r3','Hey hey','2025-09-24 22:46:13.721',NULL,'sent','[]','2025-09-24 22:46:13.721','2025-09-24 22:46:13.721',NULL),('cmg2r8q0w0001zj5k9h4u617c','cmftyt6110009wjtcgfgbz5el','cmfuvubvx0001wj7chgmj13zk','cmfuvubvx0001wj7chgmj13zk','cmftyt5y60005wjtc0u84j1r3','Test message from script','2025-09-27 21:00:16.390',NULL,'sent','[]','2025-09-27 21:00:16.390','2025-09-27 21:00:16.390',NULL),('cmg2saut70002zj8grmlrrmke','cmfuvubvx0001wj7chgmj13zk','cmftyt6110009wjtcgfgbz5el','cmfuvubvx0001wj7chgmj13zk','cmftyt5y60005wjtc0u84j1r3','This is received','2025-09-27 21:29:55.272',NULL,'sent','[]','2025-09-27 21:29:55.272','2025-09-27 21:29:55.272',NULL),('cmg2sauta0003zj8gnwt97876','cmfuvubvx0001wj7chgmj13zk','cmftyt6110009wjtcgfgbz5el','cmfuvubvx0001wj7chgmj13zk','cmftyt5y60005wjtc0u84j1r3','This is received','2025-09-27 21:29:54.494',NULL,'sent','[]','2025-09-27 21:29:54.494','2025-09-27 21:29:54.494',NULL),('cmg2scmkn0005zj8gm87uknup','cmfuvubvx0001wj7chgmj13zk','cmftyt6110009wjtcgfgbz5el','cmfuvubvx0001wj7chgmj13zk','cmftyt5y60005wjtc0u84j1r3','😇','2025-09-27 21:31:18.215',NULL,'sent','[]','2025-09-27 21:31:18.215','2025-09-27 21:31:18.215',NULL),('cmg2slfco0007zj8g1csk1c1o','cmftyt6110009wjtcgfgbz5el','cmfuvubvx0001wj7chgmj13zk','cmfuvubvx0001wj7chgmj13zk','cmftyt5y60005wjtc0u84j1r3','Oh amazing amazing, issue is fully solved','2025-09-27 21:38:08.750',NULL,'sent','[]','2025-09-27 21:38:08.750','2025-09-27 21:38:08.750',NULL),('cmg2sm0sp0009zj8gdd4unu06','cmftyt6110009wjtcgfgbz5el','cmfuvubvx0001wj7chgmj13zk','cmfuvubvx0001wj7chgmj13zk','cmftyt5y60005wjtc0u84j1r3','😍','2025-09-27 21:38:36.549',NULL,'sent','[]','2025-09-27 21:38:36.549','2025-09-27 21:38:36.549',NULL);
/*!40000 ALTER TABLE `chats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `commission_invoices`
--

DROP TABLE IF EXISTS `commission_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `commission_invoices` (
  `id` varchar(191) NOT NULL,
  `companyId` varchar(191) NOT NULL,
  `propertyId` varchar(191) NOT NULL,
  `invoiceNumber` varchar(191) NOT NULL,
  `periodStart` datetime(3) NOT NULL,
  `periodEnd` datetime(3) NOT NULL,
  `totalRentCollected` decimal(12,2) NOT NULL,
  `commissionRate` decimal(5,2) NOT NULL,
  `commissionAmount` decimal(12,2) NOT NULL,
  `status` varchar(191) NOT NULL DEFAULT 'pending',
  `dueDate` datetime(3) NOT NULL,
  `paidDate` datetime(3) DEFAULT NULL,
  `paymentMethod` varchar(191) DEFAULT NULL,
  `paymentReference` varchar(191) DEFAULT NULL,
  `notes` varchar(191) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `updatedAt` datetime(3) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `commission_invoices_invoiceNumber_key` (`invoiceNumber`),
  KEY `commission_invoices_companyId_fkey` (`companyId`),
  KEY `commission_invoices_propertyId_fkey` (`propertyId`),
  CONSTRAINT `commission_invoices_companyId_fkey` FOREIGN KEY (`companyId`) REFERENCES `companies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `commission_invoices_propertyId_fkey` FOREIGN KEY (`propertyId`) REFERENCES `properties` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `commission_invoices`
--

LOCK TABLES `commission_invoices` WRITE;
/*!40000 ALTER TABLE `commission_invoices` DISABLE KEYS */;
INSERT INTO `commission_invoices` VALUES ('cmfv71x750001wj34lbnxmrsn','cmftyt5y60005wjtc0u84j1r3','cmfu4zkae000jwjtcizl32ff3','COM-202509-0001','2025-08-31 21:00:00.000','2025-09-29 21:00:00.000',2600000.00,10.00,260000.00,'paid','2025-09-21 21:00:00.000','2025-09-22 16:11:38.283','mobile_money','Payment claim cmfvbofh90007wj34tk11iwfu','Payment approved by SirRichard Miyingo','2025-09-22 14:00:43.591','2025-09-22 16:11:38.285'),('cmfx3nye70001wj0cgvxvojmk','cmftyt5y60005wjtc0u84j1r3','cmfvbvz6h0009wj349tntg1si','COM-202509-NTG1SI-24','2025-08-31 21:00:00.000','2025-09-29 21:00:00.000',1200000.00,10.00,120000.00,'paid','2025-09-23 21:00:00.000','2025-09-24 08:37:28.738','mobile_money','Payment claim cmfxpxj110007wjq481fdx09z','Payment approved by SirRichard Miyingo','2025-09-23 22:01:25.471','2025-09-24 08:37:28.743');
/*!40000 ALTER TABLE `commission_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `companies`
--

DROP TABLE IF EXISTS `companies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `companies` (
  `id` varchar(191) NOT NULL,
  `name` varchar(191) NOT NULL,
  `email` varchar(191) NOT NULL,
  `phone` varchar(191) DEFAULT NULL,
  `address` varchar(191) DEFAULT NULL,
  `logoUrl` varchar(191) DEFAULT NULL,
  `website` varchar(191) DEFAULT NULL,
  `bankName` varchar(191) DEFAULT NULL,
  `bankAccountNumber` varchar(191) DEFAULT NULL,
  `bankAccountName` varchar(191) DEFAULT NULL,
  `commissionRate` decimal(5,2) NOT NULL DEFAULT 10.00,
  `commissionDueDay` int(11) NOT NULL DEFAULT 1,
  `rentDueDay` int(11) NOT NULL DEFAULT 1,
  `baseCurrency` varchar(191) NOT NULL DEFAULT 'UGX',
  `usdToUgxRate` decimal(10,2) NOT NULL DEFAULT 3700.00,
  `subscriptionPlanId` varchar(191) DEFAULT NULL,
  `subscriptionStatus` varchar(191) NOT NULL DEFAULT 'active',
  `subscriptionStartDate` datetime(3) DEFAULT NULL,
  `subscriptionEndDate` datetime(3) DEFAULT NULL,
  `stripeCustomerId` varchar(191) DEFAULT NULL,
  `stripeSubscriptionId` varchar(191) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `updatedAt` datetime(3) NOT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `companies_email_key` (`email`),
  UNIQUE KEY `companies_stripeCustomerId_key` (`stripeCustomerId`),
  UNIQUE KEY `companies_stripeSubscriptionId_key` (`stripeSubscriptionId`),
  KEY `companies_subscriptionPlanId_fkey` (`subscriptionPlanId`),
  CONSTRAINT `companies_subscriptionPlanId_fkey` FOREIGN KEY (`subscriptionPlanId`) REFERENCES `subscription_plans` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `companies`
--

LOCK TABLES `companies` WRITE;
/*!40000 ALTER TABLE `companies` DISABLE KEYS */;
INSERT INTO `companies` VALUES ('cmftyt5y60005wjtc0u84j1r3','Feynman Properties Ltd','richardmiyingo@gmail.com','256754273128','Kiwatule, Kampala, Uganda','/uploads/logos/1758491469575-de6bbdef-6d85-480b-8ecb-b104dc0764ee.PNG','feynmanproperties.com','Stanbic Bank','1234567890','Feynman Properties Ltd',10.00,1,1,'UGX',3700.00,'cmftyt5t90000wjtcoszj489j','active','2025-09-21 17:22:11.907',NULL,NULL,NULL,'2025-09-21 17:22:11.919','2025-09-21 22:22:44.313',NULL),('cmg72d05i0001zji0827yxrot','Southend Properties Ltd','itdeptsouthend@gmail.com','0705232929','Kiwatule, Kampala, Uganda',NULL,'https://southendpropertieslimited.com',NULL,NULL,NULL,5.00,1,1,'USD',3700.00,'cmftyt5tk0001wjtcf4wc3y8z','active','2025-10-01 00:00:00.000','2025-10-31 00:00:00.000',NULL,NULL,'2025-09-30 21:22:36.667','2025-09-30 21:25:35.277',NULL);
/*!40000 ALTER TABLE `companies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estates`
--

DROP TABLE IF EXISTS `estates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estates` (
  `id` varchar(191) NOT NULL,
  `companyId` varchar(191) NOT NULL,
  `name` varchar(191) NOT NULL,
  `description` varchar(191) DEFAULT NULL,
  `location` varchar(191) NOT NULL,
  `streetAddress` varchar(191) DEFAULT NULL,
  `city` varchar(191) NOT NULL,
  `district` varchar(191) DEFAULT NULL,
  `region` varchar(191) DEFAULT NULL,
  `postalCode` varchar(191) DEFAULT NULL,
  `country` varchar(191) NOT NULL DEFAULT 'Uganda',
  `totalProperties` int(11) NOT NULL DEFAULT 0,
  `totalUnits` int(11) NOT NULL DEFAULT 0,
  `amenities` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`amenities`)),
  `images` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`images`)),
  `documents` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`documents`)),
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `updatedAt` datetime(3) NOT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `estates_companyId_fkey` (`companyId`),
  CONSTRAINT `estates_companyId_fkey` FOREIGN KEY (`companyId`) REFERENCES `companies` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estates`
--

LOCK TABLES `estates` WRITE;
/*!40000 ALTER TABLE `estates` DISABLE KEYS */;
INSERT INTO `estates` VALUES ('cmfu4pc4o000hwjtcbi9ipyy7','cmftyt5y60005wjtc0u84j1r3','Nakasero estate','This is a test description of the estate','Nakasero, central kampala','Plot 123, kampala road','Kampala','Kampala','Central','256','Uganda',1,0,'[\"Security\",\"Generator\",\"Garden\",\"CCTV\",\"Gate\",\"Street Lighting\"]','[\"/api/uploads/estates/1758485229507-0-kdq7fdowr/2150799723.jpg\"]','[]','2025-09-21 20:07:10.163','2025-09-21 20:15:08.495',NULL);
/*!40000 ALTER TABLE `estates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exchange_rates`
--

DROP TABLE IF EXISTS `exchange_rates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `exchange_rates` (
  `id` varchar(191) NOT NULL,
  `fromCurrency` varchar(191) NOT NULL DEFAULT 'USD',
  `toCurrency` varchar(191) NOT NULL DEFAULT 'UGX',
  `rate` decimal(10,2) NOT NULL,
  `source` varchar(191) DEFAULT NULL,
  `effectiveDate` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  PRIMARY KEY (`id`),
  UNIQUE KEY `exchange_rates_fromCurrency_toCurrency_effectiveDate_key` (`fromCurrency`,`toCurrency`,`effectiveDate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exchange_rates`
--

LOCK TABLES `exchange_rates` WRITE;
/*!40000 ALTER TABLE `exchange_rates` DISABLE KEYS */;
/*!40000 ALTER TABLE `exchange_rates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `financial_transactions`
--

DROP TABLE IF EXISTS `financial_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `financial_transactions` (
  `id` varchar(191) NOT NULL,
  `companyId` varchar(191) NOT NULL,
  `propertyId` varchar(191) DEFAULT NULL,
  `tenantId` varchar(191) DEFAULT NULL,
  `paymentId` varchar(191) DEFAULT NULL,
  `transactionType` varchar(191) NOT NULL,
  `category` varchar(191) DEFAULT NULL,
  `amount` decimal(12,2) NOT NULL,
  `amountUsd` decimal(10,2) DEFAULT NULL,
  `exchangeRate` decimal(10,2) DEFAULT NULL,
  `description` varchar(191) DEFAULT NULL,
  `transactionDate` datetime(3) NOT NULL,
  `referenceNumber` varchar(191) DEFAULT NULL,
  `receiptUrl` varchar(191) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `updatedAt` datetime(3) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `financial_transactions_companyId_fkey` (`companyId`),
  KEY `financial_transactions_propertyId_fkey` (`propertyId`),
  CONSTRAINT `financial_transactions_companyId_fkey` FOREIGN KEY (`companyId`) REFERENCES `companies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `financial_transactions_propertyId_fkey` FOREIGN KEY (`propertyId`) REFERENCES `properties` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `financial_transactions`
--

LOCK TABLES `financial_transactions` WRITE;
/*!40000 ALTER TABLE `financial_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `financial_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `lease_documents`
--

DROP TABLE IF EXISTS `lease_documents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `lease_documents` (
  `id` varchar(191) NOT NULL,
  `companyId` varchar(191) NOT NULL,
  `tenantId` varchar(191) NOT NULL,
  `unitId` varchar(191) NOT NULL,
  `title` varchar(191) NOT NULL,
  `description` varchar(191) DEFAULT NULL,
  `documentType` varchar(191) NOT NULL DEFAULT 'lease_agreement',
  `documentUrl` varchar(191) NOT NULL,
  `status` varchar(191) NOT NULL DEFAULT 'draft',
  `effectiveDate` datetime(3) DEFAULT NULL,
  `expirationDate` datetime(3) DEFAULT NULL,
  `tenantSigned` tinyint(1) NOT NULL DEFAULT 0,
  `tenantSignedAt` datetime(3) DEFAULT NULL,
  `companySigned` tinyint(1) NOT NULL DEFAULT 0,
  `companySignedAt` datetime(3) DEFAULT NULL,
  `version` int(11) NOT NULL DEFAULT 1,
  `parentDocumentId` varchar(191) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `updatedAt` datetime(3) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `lease_documents_companyId_fkey` (`companyId`),
  KEY `lease_documents_tenantId_fkey` (`tenantId`),
  KEY `lease_documents_unitId_fkey` (`unitId`),
  CONSTRAINT `lease_documents_companyId_fkey` FOREIGN KEY (`companyId`) REFERENCES `companies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `lease_documents_tenantId_fkey` FOREIGN KEY (`tenantId`) REFERENCES `tenants` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `lease_documents_unitId_fkey` FOREIGN KEY (`unitId`) REFERENCES `units` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `lease_documents`
--

LOCK TABLES `lease_documents` WRITE;
/*!40000 ALTER TABLE `lease_documents` DISABLE KEYS */;
/*!40000 ALTER TABLE `lease_documents` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `maintenance_requests`
--

DROP TABLE IF EXISTS `maintenance_requests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `maintenance_requests` (
  `id` varchar(191) NOT NULL,
  `propertyId` varchar(191) NOT NULL,
  `tenantId` varchar(191) DEFAULT NULL,
  `companyId` varchar(191) NOT NULL,
  `assignedToId` varchar(191) DEFAULT NULL,
  `title` varchar(191) NOT NULL,
  `description` varchar(191) NOT NULL,
  `category` varchar(191) DEFAULT NULL,
  `priority` varchar(191) NOT NULL DEFAULT 'medium',
  `status` varchar(191) NOT NULL DEFAULT 'open',
  `requestedDate` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `scheduledDate` datetime(3) DEFAULT NULL,
  `completedDate` datetime(3) DEFAULT NULL,
  `estimatedCost` decimal(10,2) DEFAULT NULL,
  `actualCost` decimal(10,2) DEFAULT NULL,
  `images` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`images`)),
  `documents` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`documents`)),
  `tenantNotes` varchar(191) DEFAULT NULL,
  `internalNotes` varchar(191) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `updatedAt` datetime(3) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `maintenance_requests_propertyId_fkey` (`propertyId`),
  KEY `maintenance_requests_tenantId_fkey` (`tenantId`),
  KEY `maintenance_requests_companyId_fkey` (`companyId`),
  KEY `maintenance_requests_assignedToId_fkey` (`assignedToId`),
  CONSTRAINT `maintenance_requests_assignedToId_fkey` FOREIGN KEY (`assignedToId`) REFERENCES `technicians` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `maintenance_requests_companyId_fkey` FOREIGN KEY (`companyId`) REFERENCES `companies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `maintenance_requests_propertyId_fkey` FOREIGN KEY (`propertyId`) REFERENCES `properties` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `maintenance_requests_tenantId_fkey` FOREIGN KEY (`tenantId`) REFERENCES `tenants` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `maintenance_requests`
--

LOCK TABLES `maintenance_requests` WRITE;
/*!40000 ALTER TABLE `maintenance_requests` DISABLE KEYS */;
/*!40000 ALTER TABLE `maintenance_requests` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notifications`
--

DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notifications` (
  `id` varchar(191) NOT NULL,
  `userId` varchar(191) NOT NULL,
  `companyId` varchar(191) DEFAULT NULL,
  `title` varchar(191) NOT NULL,
  `message` varchar(191) NOT NULL,
  `type` varchar(191) DEFAULT NULL,
  `isRead` tinyint(1) NOT NULL DEFAULT 0,
  `readAt` datetime(3) DEFAULT NULL,
  `deliveryMethod` varchar(191) NOT NULL DEFAULT 'in_app',
  `sentAt` datetime(3) DEFAULT NULL,
  `relatedEntityType` varchar(191) DEFAULT NULL,
  `relatedEntityId` varchar(191) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  PRIMARY KEY (`id`),
  KEY `notifications_userId_fkey` (`userId`),
  KEY `notifications_companyId_fkey` (`companyId`),
  CONSTRAINT `notifications_companyId_fkey` FOREIGN KEY (`companyId`) REFERENCES `companies` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `notifications_userId_fkey` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notifications`
--

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `owner_statements`
--

DROP TABLE IF EXISTS `owner_statements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `owner_statements` (
  `id` varchar(191) NOT NULL,
  `ownerId` varchar(191) NOT NULL,
  `companyId` varchar(191) NOT NULL,
  `month` varchar(191) NOT NULL,
  `fileUrl` varchar(191) NOT NULL,
  `fileName` varchar(191) NOT NULL,
  `fileSize` int(11) NOT NULL,
  `uploadedBy` varchar(191) NOT NULL,
  `uploadedAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `status` varchar(191) NOT NULL DEFAULT 'active',
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `updatedAt` datetime(3) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `owner_statements_ownerId_month_key` (`ownerId`,`month`),
  KEY `owner_statements_companyId_fkey` (`companyId`),
  CONSTRAINT `owner_statements_companyId_fkey` FOREIGN KEY (`companyId`) REFERENCES `companies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `owner_statements_ownerId_fkey` FOREIGN KEY (`ownerId`) REFERENCES `users` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `owner_statements`
--

LOCK TABLES `owner_statements` WRITE;
/*!40000 ALTER TABLE `owner_statements` DISABLE KEYS */;
INSERT INTO `owner_statements` VALUES ('cmfva4qaf0005wj34y8hxpx5q','cmfv2199p0001wjm0wt0w5mkp','cmftyt5y60005wjtc0u84j1r3','2025-09','/api/uploads/owner-statements/1758554813447-7340.pdf','Innovation and Technology Scholarship - Frequently Asked Questions.pdf',237542,'cmftyt6110009wjtcgfgbz5el','2025-09-22 15:26:53.463','active','2025-09-22 15:26:53.463','2025-09-22 15:26:53.463'),('cmfy8a8ri000bwjq4mpz7bme5','cmfva2di60003wj34pfix4jyg','cmftyt5y60005wjtc0u84j1r3','2025-09','/api/uploads/owner-statements/1758733109954-874.pdf','NATIONAL I.D -CHRIS.pdf',195536,'cmftyt6110009wjtcgfgbz5el','2025-09-24 16:58:29.973','active','2025-09-24 16:58:29.973','2025-09-24 16:58:29.973');
/*!40000 ALTER TABLE `owner_statements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment_claims`
--

DROP TABLE IF EXISTS `payment_claims`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `payment_claims` (
  `id` varchar(191) NOT NULL,
  `invoiceId` varchar(191) NOT NULL,
  `ownerId` varchar(191) NOT NULL,
  `companyId` varchar(191) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `paymentMethod` varchar(191) NOT NULL,
  `notes` varchar(191) DEFAULT NULL,
  `status` varchar(191) NOT NULL DEFAULT 'pending',
  `claimedAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `approvedAt` datetime(3) DEFAULT NULL,
  `approvedBy` varchar(191) DEFAULT NULL,
  `receiptUrl` varchar(191) DEFAULT NULL,
  `rejectionReason` varchar(191) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `updatedAt` datetime(3) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `payment_claims_companyId_fkey` (`companyId`),
  CONSTRAINT `payment_claims_companyId_fkey` FOREIGN KEY (`companyId`) REFERENCES `companies` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment_claims`
--

LOCK TABLES `payment_claims` WRITE;
/*!40000 ALTER TABLE `payment_claims` DISABLE KEYS */;
INSERT INTO `payment_claims` VALUES ('cmfvbofh90007wj34tk11iwfu','cmfv71x750001wj34lbnxmrsn','cmfv2199p0001wjm0wt0w5mkp','cmftyt5y60005wjtc0u84j1r3',260000.00,'mobile_money','Test notes for payment of commission','approved','2025-09-22 16:10:12.186','2025-09-22 16:11:38.255','cmftyt6110009wjtcgfgbz5el',NULL,NULL,'2025-09-22 16:10:12.186','2025-09-22 16:11:38.257'),('cmfxpxj110007wjq481fdx09z','cmfx3nye70001wj0cgvxvojmk','cmfva2di60003wj34pfix4jyg','cmftyt5y60005wjtc0u84j1r3',120000.00,'mobile_money','Sent via Mobile money to Mr.Chris','approved','2025-09-24 08:24:43.654','2025-09-24 08:37:28.710','cmftyt6110009wjtcgfgbz5el',NULL,NULL,'2025-09-24 08:24:43.654','2025-09-24 08:37:28.713');
/*!40000 ALTER TABLE `payment_claims` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `payments` (
  `id` varchar(191) NOT NULL,
  `tenantId` varchar(191) NOT NULL,
  `unitId` varchar(191) NOT NULL,
  `companyId` varchar(191) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `amountUsd` decimal(10,2) DEFAULT NULL,
  `exchangeRate` decimal(10,2) DEFAULT NULL,
  `paymentType` varchar(191) NOT NULL DEFAULT 'rent',
  `description` varchar(191) DEFAULT NULL,
  `dueDate` datetime(3) NOT NULL,
  `paidDate` datetime(3) DEFAULT NULL,
  `status` varchar(191) NOT NULL DEFAULT 'pending',
  `paymentMethod` varchar(191) DEFAULT NULL,
  `lateFeeAmount` decimal(10,2) NOT NULL DEFAULT 0.00,
  `lateFeeAppliedDate` datetime(3) DEFAULT NULL,
  `stripePaymentIntentId` varchar(191) DEFAULT NULL,
  `stripeChargeId` varchar(191) DEFAULT NULL,
  `bankTransferProof` varchar(191) DEFAULT NULL,
  `bankTransferReference` varchar(191) DEFAULT NULL,
  `approvedBy` varchar(191) DEFAULT NULL,
  `approvedAt` datetime(3) DEFAULT NULL,
  `rejectedReason` varchar(191) DEFAULT NULL,
  `mobileMoneyProvider` varchar(191) DEFAULT NULL,
  `mobileMoneyReference` varchar(191) DEFAULT NULL,
  `mobileMoneyPhone` varchar(191) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `updatedAt` datetime(3) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `payments_tenantId_fkey` (`tenantId`),
  KEY `payments_unitId_fkey` (`unitId`),
  KEY `payments_companyId_fkey` (`companyId`),
  CONSTRAINT `payments_companyId_fkey` FOREIGN KEY (`companyId`) REFERENCES `companies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `payments_tenantId_fkey` FOREIGN KEY (`tenantId`) REFERENCES `tenants` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `payments_unitId_fkey` FOREIGN KEY (`unitId`) REFERENCES `units` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `properties`
--

DROP TABLE IF EXISTS `properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `properties` (
  `id` varchar(191) NOT NULL,
  `companyId` varchar(191) NOT NULL,
  `estateId` varchar(191) DEFAULT NULL,
  `ownerId` varchar(191) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `description` varchar(191) DEFAULT NULL,
  `propertyType` varchar(191) DEFAULT NULL,
  `purchasePrice` decimal(15,2) DEFAULT NULL,
  `currentMarketValue` decimal(15,2) DEFAULT NULL,
  `totalUnits` int(11) NOT NULL DEFAULT 1,
  `totalFloors` int(11) DEFAULT NULL,
  `yearBuilt` int(11) DEFAULT NULL,
  `status` varchar(191) NOT NULL DEFAULT 'active',
  `amenities` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`amenities`)),
  `images` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`images`)),
  `documents` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`documents`)),
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `updatedAt` datetime(3) NOT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  `propertyLocation` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `properties_companyId_fkey` (`companyId`),
  KEY `properties_ownerId_fkey` (`ownerId`),
  KEY `properties_estateId_fkey` (`estateId`),
  CONSTRAINT `properties_companyId_fkey` FOREIGN KEY (`companyId`) REFERENCES `companies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `properties_estateId_fkey` FOREIGN KEY (`estateId`) REFERENCES `estates` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `properties_ownerId_fkey` FOREIGN KEY (`ownerId`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `properties`
--

LOCK TABLES `properties` WRITE;
/*!40000 ALTER TABLE `properties` DISABLE KEYS */;
INSERT INTO `properties` VALUES ('cmfu4zkae000jwjtcizl32ff3','cmftyt5y60005wjtc0u84j1r3','cmfu4pc4o000hwjtcbi9ipyy7','cmfv2199p0001wjm0wt0w5mkp','Sunrise Apartment','Test description goes here','apartment_building',850000000.00,16000000000.00,52,5,2022,'active','[\"Parking\",\"Security\",\"Generator\",\"Water Tank\",\"Gym\",\"Elevator\",\"Gate\",\"CCTV\",\"Fence\"]','[]','[]','2025-09-21 20:15:08.101','2025-09-22 13:59:14.527',NULL,'Plot 123, Kampala road'),('cmfvbvz6h0009wj349tntg1si','cmftyt5y60005wjtc0u84j1r3',NULL,'cmfva2di60003wj34pfix4jyg','Feynman Tower','Owner description for owner','commercial',15000000.00,20000000000.00,122,8,2018,'active','[\"Parking\",\"Security\",\"Generator\",\"Water Tank\",\"CCTV\",\"Elevator\",\"Gate\"]','[]','[]','2025-09-22 16:16:04.309','2025-09-24 10:52:18.022',NULL,'Plot 123, Kampala, Uganda');
/*!40000 ALTER TABLE `properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rent_invoices`
--

DROP TABLE IF EXISTS `rent_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rent_invoices` (
  `id` varchar(191) NOT NULL,
  `companyId` varchar(191) NOT NULL,
  `tenantId` varchar(191) NOT NULL,
  `unitId` varchar(191) DEFAULT NULL,
  `propertyId` varchar(191) DEFAULT NULL,
  `invoiceNumber` varchar(191) NOT NULL,
  `invoiceDate` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `dueDate` datetime(3) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `amountUsd` decimal(10,2) DEFAULT NULL,
  `exchangeRate` decimal(10,2) DEFAULT NULL,
  `status` varchar(191) NOT NULL DEFAULT 'pending',
  `paidDate` datetime(3) DEFAULT NULL,
  `paymentMethod` varchar(191) DEFAULT NULL,
  `paymentId` varchar(191) DEFAULT NULL,
  `description` varchar(191) DEFAULT NULL,
  `notes` varchar(191) DEFAULT NULL,
  `lateFeeAmount` decimal(10,2) NOT NULL DEFAULT 0.00,
  `lateFeeAppliedDate` datetime(3) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `updatedAt` datetime(3) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `rent_invoices_invoiceNumber_key` (`invoiceNumber`),
  KEY `rent_invoices_companyId_fkey` (`companyId`),
  KEY `rent_invoices_tenantId_fkey` (`tenantId`),
  KEY `rent_invoices_unitId_fkey` (`unitId`),
  KEY `rent_invoices_propertyId_fkey` (`propertyId`),
  CONSTRAINT `rent_invoices_companyId_fkey` FOREIGN KEY (`companyId`) REFERENCES `companies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `rent_invoices_propertyId_fkey` FOREIGN KEY (`propertyId`) REFERENCES `properties` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `rent_invoices_tenantId_fkey` FOREIGN KEY (`tenantId`) REFERENCES `tenants` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `rent_invoices_unitId_fkey` FOREIGN KEY (`unitId`) REFERENCES `units` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rent_invoices`
--

LOCK TABLES `rent_invoices` WRITE;
/*!40000 ALTER TABLE `rent_invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `rent_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `subscription_plans`
--

DROP TABLE IF EXISTS `subscription_plans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `subscription_plans` (
  `id` varchar(191) NOT NULL,
  `name` varchar(191) NOT NULL,
  `description` varchar(191) DEFAULT NULL,
  `priceMonthly` decimal(10,2) NOT NULL,
  `priceYearly` decimal(10,2) DEFAULT NULL,
  `propertiesLimit` int(11) DEFAULT NULL,
  `tenantsLimit` int(11) DEFAULT NULL,
  `ownersLimit` int(11) DEFAULT NULL,
  `storageLimitGb` int(11) DEFAULT NULL,
  `features` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`features`)),
  `isActive` tinyint(1) NOT NULL DEFAULT 1,
  `sortOrder` int(11) NOT NULL DEFAULT 0,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `updatedAt` datetime(3) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `subscription_plans`
--

LOCK TABLES `subscription_plans` WRITE;
/*!40000 ALTER TABLE `subscription_plans` DISABLE KEYS */;
INSERT INTO `subscription_plans` VALUES ('cmftyt5t90000wjtcoszj489j','Basic','Basic plan for small property managers',49.00,490.00,5,25,5,1,'{\"maintenance_tracking\":false,\"advanced_analytics\":false,\"tenant_screening\":false,\"automated_rent_collection\":true,\"basic_reporting\":true}',1,1,'2025-09-21 17:22:11.747','2025-09-21 17:22:11.747'),('cmftyt5tk0001wjtcf4wc3y8z','Standard','Standard plan for growing businesses',149.00,1490.00,25,100,20,5,'{\"maintenance_tracking\":true,\"advanced_analytics\":false,\"tenant_screening\":false,\"automated_rent_collection\":true,\"basic_reporting\":true,\"financial_reports\":true}',1,2,'2025-09-21 17:22:11.747','2025-09-21 17:22:11.747'),('cmftyt5tm0002wjtc1zi90k8j','Premium','Premium plan for established companies',399.00,3990.00,100,500,50,20,'{\"maintenance_tracking\":true,\"advanced_analytics\":true,\"tenant_screening\":true,\"automated_rent_collection\":true,\"basic_reporting\":true,\"financial_reports\":true,\"priority_support\":true}',1,3,'2025-09-21 17:22:11.747','2025-09-21 17:22:11.747'),('cmftyt5to0003wjtcnvbth9qe','Enterprise','Enterprise plan for large organizations',999.00,9990.00,NULL,NULL,NULL,NULL,'{\"maintenance_tracking\":true,\"advanced_analytics\":true,\"tenant_screening\":true,\"automated_rent_collection\":true,\"basic_reporting\":true,\"financial_reports\":true,\"priority_support\":true,\"white_label\":true,\"api_access\":true,\"custom_integrations\":true}',1,4,'2025-09-21 17:22:11.747','2025-09-21 17:22:11.747');
/*!40000 ALTER TABLE `subscription_plans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `subscription_usage`
--

DROP TABLE IF EXISTS `subscription_usage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `subscription_usage` (
  `id` varchar(191) NOT NULL,
  `companyId` varchar(191) NOT NULL,
  `propertiesCount` int(11) NOT NULL DEFAULT 0,
  `unitsCount` int(11) NOT NULL DEFAULT 0,
  `tenantsCount` int(11) NOT NULL DEFAULT 0,
  `ownersCount` int(11) NOT NULL DEFAULT 0,
  `storageUsedGb` decimal(10,2) NOT NULL DEFAULT 0.00,
  `periodStart` datetime(3) NOT NULL,
  `periodEnd` datetime(3) NOT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `updatedAt` datetime(3) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `subscription_usage_companyId_fkey` (`companyId`),
  CONSTRAINT `subscription_usage_companyId_fkey` FOREIGN KEY (`companyId`) REFERENCES `companies` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `subscription_usage`
--

LOCK TABLES `subscription_usage` WRITE;
/*!40000 ALTER TABLE `subscription_usage` DISABLE KEYS */;
INSERT INTO `subscription_usage` VALUES ('cmftyt6070007wjtcfuc4dmc3','cmftyt5y60005wjtc0u84j1r3',0,0,0,0,0.00,'2025-09-21 17:22:12.002','2025-10-21 17:22:12.002','2025-09-21 17:22:12.004','2025-09-21 17:22:12.004');
/*!40000 ALTER TABLE `subscription_usage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `technicians`
--

DROP TABLE IF EXISTS `technicians`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `technicians` (
  `id` varchar(191) NOT NULL,
  `companyId` varchar(191) NOT NULL,
  `firstName` varchar(191) NOT NULL,
  `lastName` varchar(191) NOT NULL,
  `email` varchar(191) NOT NULL,
  `phone` varchar(191) DEFAULT NULL,
  `address` varchar(191) DEFAULT NULL,
  `passwordHash` varchar(191) DEFAULT NULL,
  `specialization` varchar(191) DEFAULT NULL,
  `experienceYears` int(11) DEFAULT 0,
  `certifications` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`certifications`)),
  `completedRequests` int(11) NOT NULL DEFAULT 0,
  `averageRating` decimal(3,2) DEFAULT NULL,
  `totalEarnings` decimal(12,2) NOT NULL DEFAULT 0.00,
  `status` varchar(191) NOT NULL DEFAULT 'active',
  `hireDate` datetime(3) DEFAULT NULL,
  `terminationDate` datetime(3) DEFAULT NULL,
  `emergencyContactName` varchar(191) DEFAULT NULL,
  `emergencyContactPhone` varchar(191) DEFAULT NULL,
  `notes` varchar(191) DEFAULT NULL,
  `avatarUrl` varchar(191) DEFAULT NULL,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `updatedAt` datetime(3) NOT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `technicians_email_key` (`email`),
  KEY `technicians_companyId_fkey` (`companyId`),
  CONSTRAINT `technicians_companyId_fkey` FOREIGN KEY (`companyId`) REFERENCES `companies` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `technicians`
--

LOCK TABLES `technicians` WRITE;
/*!40000 ALTER TABLE `technicians` DISABLE KEYS */;
/*!40000 ALTER TABLE `technicians` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tenant_users`
--

DROP TABLE IF EXISTS `tenant_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tenant_users` (
  `id` varchar(191) NOT NULL,
  `userId` varchar(191) NOT NULL,
  `tenantId` varchar(191) NOT NULL,
  `canMakePayments` tinyint(1) NOT NULL DEFAULT 1,
  `canRequestMaintenance` tinyint(1) NOT NULL DEFAULT 1,
  `canViewDocuments` tinyint(1) NOT NULL DEFAULT 1,
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `updatedAt` datetime(3) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `tenant_users_userId_key` (`userId`),
  UNIQUE KEY `tenant_users_tenantId_key` (`tenantId`),
  CONSTRAINT `tenant_users_tenantId_fkey` FOREIGN KEY (`tenantId`) REFERENCES `tenants` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `tenant_users_userId_fkey` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tenant_users`
--

LOCK TABLES `tenant_users` WRITE;
/*!40000 ALTER TABLE `tenant_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `tenant_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tenants`
--

DROP TABLE IF EXISTS `tenants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tenants` (
  `id` varchar(191) NOT NULL,
  `companyId` varchar(191) NOT NULL,
  `unitId` varchar(191) DEFAULT NULL,
  `firstName` varchar(191) NOT NULL,
  `lastName` varchar(191) NOT NULL,
  `email` varchar(191) DEFAULT NULL,
  `phone` varchar(191) DEFAULT NULL,
  `passwordHash` varchar(191) DEFAULT NULL,
  `nationalId` varchar(191) DEFAULT NULL,
  `emergencyContactName` varchar(191) DEFAULT NULL,
  `emergencyContactPhone` varchar(191) DEFAULT NULL,
  `emergencyContactRelationship` varchar(191) DEFAULT NULL,
  `leaseStartDate` datetime(3) NOT NULL,
  `leaseEndDate` datetime(3) NOT NULL,
  `monthlyRent` decimal(10,2) NOT NULL,
  `securityDeposit` decimal(10,2) DEFAULT NULL,
  `rentDueDay` int(11) NOT NULL DEFAULT 1,
  `status` varchar(191) NOT NULL DEFAULT 'active',
  `moveInDate` datetime(3) DEFAULT NULL,
  `moveOutDate` datetime(3) DEFAULT NULL,
  `isPrimaryTenant` tinyint(1) NOT NULL DEFAULT 0,
  `notes` varchar(191) DEFAULT NULL,
  `documents` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`documents`)),
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `updatedAt` datetime(3) NOT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tenants_companyId_fkey` (`companyId`),
  KEY `tenants_unitId_fkey` (`unitId`),
  CONSTRAINT `tenants_companyId_fkey` FOREIGN KEY (`companyId`) REFERENCES `companies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `tenants_unitId_fkey` FOREIGN KEY (`unitId`) REFERENCES `units` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tenants`
--

LOCK TABLES `tenants` WRITE;
/*!40000 ALTER TABLE `tenants` DISABLE KEYS */;
INSERT INTO `tenants` VALUES ('cmfuaiav60001wj6okiqwhak1','cmftyt5y60005wjtc0u84j1r3','cmfu6vvhg000lwjtc4na85vdw','Richard','Miyingo','richtechultd@gmail.com','25654273128','$2a$12$ign2Smo8iTw55slA8qM0yuK6sozSxPjbNewvEjF7dnLKm.g2CsRAG',NULL,'Miyingo Amity','25654273128','sibling','2025-09-22 00:00:00.000','2026-09-22 00:00:00.000',1200000.00,1496000.00,22,'active','2025-09-22 00:00:00.000',NULL,1,'Tenant notes go here...........','[\"/api/uploads/tenants/cmfuaiav60001wj6okiqwhak1/documents/1758494980516-2028.png\"]','2025-09-21 22:49:40.471','2025-09-21 22:49:40.525',NULL),('cmfubcj7i0005wj6o9l60a84e','cmftyt5y60005wjtc0u84j1r3','cmfub5kpq0003wj6oyxk5jkp4','Ronald','Nyanzi','ndejjesscompdept@gmail.com','+256787583222','$2a$12$ukV/YBAkrs9ygwurSF1sLOh0v8srAv1NzTZXCQfashnh0qgxbP.BO',NULL,'Richard Miyingo','+256787583243','friend','2025-09-22 00:00:00.000','2026-09-22 00:00:00.000',1400000.00,1498000.00,22,'active','2025-09-22 00:00:00.000',NULL,1,'Tenant description','[\"/api/uploads/tenants/cmfubcj7i0005wj6o9l60a84e/documents/1758496391068-1344.png\"]','2025-09-21 23:13:10.952','2025-09-21 23:13:11.091',NULL),('cmfuvubvx0001wj7chgmj13zk','cmftyt5y60005wjtc0u84j1r3','cmfxv7b1c0009wjq4hn9sf5vz','SirRichard','Feynman','miyingo@amityonline.com','0754273338','$2a$12$IfnDYFq5V..YU//08FbRQe68zbAy0zdNWUzX1ITHj0AWzLlcpEKu6',NULL,'Richard Miyingo','+256787583243','friend','2025-09-22 00:00:00.000','2026-09-22 00:00:00.000',3000000.00,5500000.00,25,'active',NULL,NULL,1,'Any notes','[\"/api/uploads/tenants/cmfuvubvx0001wj7chgmj13zk/documents/1758719354322-5337.docx\"]','2025-09-22 08:46:53.608','2025-09-26 06:35:26.087',NULL),('cmfvgcj5i000dwj343w6ukgbc','cmftyt5y60005wjtc0u84j1r3','cmfvd1ofa000bwj34mood7jdi','Rosette','SouthEnd','rosette@southendpropertieslimited.com','0754273334','$2a$12$sx51oezmGqY.vx9VNoK/5OAQo83N5/KIrlEMuklFgl8DiTKDWbMeq',NULL,'Richard Miyingo','+256787583243','friend','2025-09-22 00:00:00.000','2026-09-22 00:00:00.000',1200000.00,1500000.00,22,'active','2025-09-22 00:00:00.000',NULL,1,'Any notes here','[\"/api/uploads/tenants/cmfvgcj5i000dwj343w6ukgbc/documents/1758565255446-1314.png\"]','2025-09-22 18:20:55.101','2025-09-25 21:47:39.442',NULL),('cmfzi6j3v0005zjrk68b29enb','cmftyt5y60005wjtc0u84j1r3',NULL,'Nicholas','Najuna','nicho.najuna@gmail.com','+256787445566','$2a$12$IBHZwAofr.PBDMIOSejHzeZMiFFuEctO0myHLp6AOrXQnyEP2N1qy',NULL,NULL,NULL,NULL,'2025-09-25 14:23:19.067','2026-09-25 14:23:19.067',0.00,NULL,1,'pending',NULL,NULL,0,NULL,'[]','2025-09-25 14:23:19.079','2025-09-25 14:23:19.148',NULL);
/*!40000 ALTER TABLE `tenants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `units`
--

DROP TABLE IF EXISTS `units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `units` (
  `id` varchar(191) NOT NULL,
  `companyId` varchar(191) NOT NULL,
  `propertyId` varchar(191) NOT NULL,
  `unitNumber` varchar(191) NOT NULL,
  `name` varchar(191) DEFAULT NULL,
  `description` varchar(191) DEFAULT NULL,
  `unitType` varchar(191) DEFAULT NULL,
  `bedrooms` int(11) DEFAULT NULL,
  `bathrooms` decimal(3,1) DEFAULT NULL,
  `squareFeet` int(11) DEFAULT NULL,
  `floorNumber` int(11) DEFAULT NULL,
  `monthlyRent` decimal(10,2) NOT NULL,
  `securityDeposit` decimal(10,2) DEFAULT NULL,
  `status` varchar(191) NOT NULL DEFAULT 'available',
  `maxOccupants` int(11) NOT NULL DEFAULT 2,
  `amenities` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`amenities`)),
  `images` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`images`)),
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `updatedAt` datetime(3) NOT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `units_propertyId_unitNumber_key` (`propertyId`,`unitNumber`),
  KEY `units_companyId_fkey` (`companyId`),
  CONSTRAINT `units_companyId_fkey` FOREIGN KEY (`companyId`) REFERENCES `companies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `units_propertyId_fkey` FOREIGN KEY (`propertyId`) REFERENCES `properties` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `units`
--

LOCK TABLES `units` WRITE;
/*!40000 ALTER TABLE `units` DISABLE KEYS */;
INSERT INTO `units` VALUES ('cmfu6vvhg000lwjtc4na85vdw','cmftyt5y60005wjtc0u84j1r3','cmfu4zkae000jwjtcizl32ff3','A1','Executive suite','The unit description','office',NULL,1.0,60,1,1200000.00,1300000.00,'occupied',5,'[\"Air Conditioning\",\"Parking\",\"Elevator\",\"Security System\"]','[\"/api/uploads/units/1758488894937-6971.jpg\"]','2025-09-21 21:08:15.050','2025-09-22 18:10:55.786',NULL),('cmfub5kpq0003wj6oyxk5jkp4','cmftyt5y60005wjtc0u84j1r3','cmfu4zkae000jwjtcizl32ff3','A2','Corner Unit','Description of Unit','office',NULL,1.0,120,1,1400000.00,1500000.00,'occupied',8,'[\"Air Conditioning\",\"Parking\",\"Elevator\",\"Security System\"]','[\"/api/uploads/units/1758496066308-7946.jpg\"]','2025-09-21 23:07:46.330','2025-09-21 23:13:11.149',NULL),('cmfvd1ofa000bwj34mood7jdi','cmftyt5y60005wjtc0u84j1r3','cmfvbvz6h0009wj349tntg1si','A01','Studio - Basement floor','The First Room when Entering the Building from Parking','office',NULL,1.0,300,NULL,1200000.00,1499996.00,'occupied',1,'[\"Air Conditioning\",\"Dishwasher\",\"Internet Ready\",\"Cable Ready\",\"CCTV\"]','[\"/uploads/property_images/1758559709897-252163ea-863e-4ce2-a7b3-b117653d901d.jpg\"]','2025-09-22 16:48:29.920','2025-09-22 18:20:55.605',NULL),('cmfxv7b1c0009wjq4hn9sf5vz','cmftyt5y60005wjtc0u84j1r3','cmfvbvz6h0009wj349tntg1si','A5','Condominium','Condominium','2_bedroom',2,2.0,115,3,3000000.00,60000000.00,'occupied',2,'[\"Air Conditioning\",\"Security System\",\"Parking\",\"Balcony\",\"Storage\",\"Walk-in Closet\"]','[\"/api/uploads/units/1758711137923-5138.jpg\"]','2025-09-24 10:52:17.939','2025-09-24 12:57:54.575',NULL);
/*!40000 ALTER TABLE `units` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` varchar(191) NOT NULL,
  `email` varchar(191) NOT NULL,
  `passwordHash` varchar(191) DEFAULT NULL,
  `firstName` varchar(191) DEFAULT NULL,
  `lastName` varchar(191) DEFAULT NULL,
  `phone` varchar(191) DEFAULT NULL,
  `avatarUrl` varchar(191) DEFAULT NULL,
  `role` varchar(191) NOT NULL,
  `companyId` varchar(191) DEFAULT NULL,
  `commissionRate` decimal(5,2) DEFAULT NULL,
  `commissionDueDay` int(11) DEFAULT 1,
  `agreementDocument` varchar(191) DEFAULT NULL,
  `emailVerified` tinyint(1) NOT NULL DEFAULT 0,
  `emailVerifiedAt` datetime(3) DEFAULT NULL,
  `lastLoginAt` datetime(3) DEFAULT NULL,
  `passwordResetToken` varchar(191) DEFAULT NULL,
  `passwordResetExpires` datetime(3) DEFAULT NULL,
  `preferences` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`preferences`)),
  `timezone` varchar(191) NOT NULL DEFAULT 'Africa/Kampala',
  `createdAt` datetime(3) NOT NULL DEFAULT current_timestamp(3),
  `updatedAt` datetime(3) NOT NULL,
  `deletedAt` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_key` (`email`),
  KEY `users_companyId_fkey` (`companyId`),
  CONSTRAINT `users_companyId_fkey` FOREIGN KEY (`companyId`) REFERENCES `companies` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES ('cmftyt6110009wjtcgfgbz5el','richardmiyingo@gmail.com','$2a$12$DRj6IdKjFzifs3oTzyzcGeArGBN6PMAZxI0.jQcTrIUTdKJygHl9m','SirRichard','Miyingo','0748130888',NULL,'company_admin','cmftyt5y60005wjtc0u84j1r3',NULL,1,NULL,0,NULL,'2025-09-27 21:33:38.826',NULL,NULL,'{}','Africa/Kampala','2025-09-21 17:22:12.036','2025-09-27 21:33:38.853',NULL),('cmftyvrmv000fwjtcubpamynb','richtechultd@gmail.com','$2a$12$7MITI38dQKHQkrU1jNteSefv8FRTfjupXfwu0bIluC5HFyndmwY52','Richard','Miyingo','0748130222',NULL,'super_admin',NULL,NULL,1,NULL,0,NULL,'2025-09-30 15:09:32.868',NULL,NULL,'{}','Africa/Kampala','2025-09-21 17:24:13.351','2025-09-30 15:09:32.875',NULL),('cmfv2199p0001wjm0wt0w5mkp','g.elimu22@gmail.com','$2a$12$DRj6IdKjFzifs3oTzyzcGeArGBN6PMAZxI0.jQcTrIUTdKJygHl9m','Owner','Gloria','0754273128',NULL,'owner','cmftyt5y60005wjtc0u84j1r3',10.00,22,'/uploads/agreements/1758541338609-455dfd6d-b82b-4772-8dce-dc854a4d9e2b.docx',0,NULL,'2025-09-24 06:10:25.545',NULL,NULL,'{}','Africa/Kampala','2025-09-22 11:40:14.506','2025-09-24 06:10:25.547',NULL),('cmfva2di60003wj34pfix4jyg','chris@southendpropertieslimited.com','$2a$12$LpZrs0vEwWXlZXLf0pvcuecBY8zMlMWbQIL58M9vCL.c05LRPlz8.','Chris','SouthEnd','+256780233682',NULL,'owner','cmftyt5y60005wjtc0u84j1r3',10.00,24,'/uploads/agreements/1758554703476-02195c9b-a3ba-4952-aaa9-143b79983606.pdf',0,NULL,'2025-09-24 16:56:49.205',NULL,NULL,'{}','Africa/Kampala','2025-09-22 15:25:03.555','2025-09-24 16:56:49.208',NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-10-01  1:12:16
